﻿var distributionLists = {
    context: $(".v-distributionLists"),
    datatable: null,
    refreshDataTable: function () {
        distributionLists.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-distributionListsTable", distributionLists.context).a4datatable({
            height: "full",
            ajaxAction: a4.getAction("GetDistributionLists", "Distributions", "Settings"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Type": "numeric", "Key": true},
                { "Name": "Name", "Title": resources.Name, "Data": "Name" },
                { "Name": "Size", "Title": resources.EmailAddresses, "Data": "Size", "Type": "numeric" },
                { "Name": "CreatedOn", "Title": resources.CreatedOn, "Data": "CreatedOn", "Type": "datetime" },
                { "Name": "LastModifiedOn", "Title": resources.LastModifiedOn, "Data": "LastModifiedOn", "Type": "datetime" }
            ],
            localizableTexts: { "Search": resources.SearchDistributionLists },
            stateKey: "DistributionLists",
            toolBarItems: distributionLists.getToolBarItems(),
            contextMenuItems: distributionLists.getContextMenuItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                }

                switch (action) {
                    case "delete":
                        distributionLists.deleteItems(ids);
                        break;
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "properties":
                        distributionLists.editItem(row.Id);
                        break;
                    case "delete":
                        distributionLists.deleteItems(row.Id);
                        break;
                }
            }
        });
    },
    deleteItems: function (items) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteItemResources, function () {
            a4.callServerMethod(a4.getAction("DeleteDistributionLists", "Distributions", "Settings"), { listIds: items },
            function (result) {
                distributionLists.refreshDataTable();
            });
        }, 250, 500, true, { "count": itemsCount });
    },
    editItem: function (itemId) {
        modalDialog.showWindow(a4.getAction("EditDistributionList", "Distributions", "Settings", { listId: itemId }), 500, null, { afterClose: distributionLists.refreshDataTable });
    },
    bindEvents: function () {
        $(".h-newList", distributionLists.context).on("click", function () {
            modalDialog.showWindow(a4.getAction("EditDistributionList", "Distributions", "Settings"), 500, null, { afterClose: distributionLists.refreshDataTable });
        });
    },
    getContextMenuItems: function () {
        if (canModify)
            return [{ "Action": "delete", "Label": resources.Delete }, { "Action": "properties", "Label": resources.Properties }];
        else
            return [];
    },
    getToolBarItems: function () {
        if (canModify)
            return [{ "Action": "delete", "Label": resources.Delete }];
        else
            return [];
    }
}

$(document).ready(function () {
    if (distributionLists.context.length > 0) {
        distributionLists.initializeDataTable();
        distributionLists.bindEvents();
    }
});